<?php
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */


    class VisualizzatoreCondivisioneFile extends VisualizzatoreComponente {
        function __construct($db) {
            parent::__construct($db);
        }
        
        function generaContenutoSezione($dati) {
            $impostazioni = parent::getDb()->leggiSingolaRiga("geec_condivisioniFile",$dati["idElemento"]);
            
            if($impostazioni["contenutoDaCondividere"]=="file") {
                $this->generaCodiceSingoloFile($impostazioni);
            }
            else {           
                $this->generaTabellaFileCartella($impostazioni);
            }
        }
        
        function generaCodiceSingoloFile($impostazioni) {
            $datiFile = parent::getDb()->leggiSingolaRiga("geecD_documenti",$impostazioni["fileDaCondividere"]);
            ?>
            <div class="col-md-8 col-lg-4 mx-auto">
                <div class="card">
                    <div class="card-body">
                        <i class="far fa-arrow-alt-circle-down fa-2x mb-2"></i>
                        <h5>Pronto per scaricare?</h5>
                        <p class=""><?= $datiFile["nome"] ?></p>
                        <small><?= $impostazioni["testo"] ?></small><hr>
                        <div class="text-right mt-3">
                            <a class="btn btn-primary scarica" href="scarica.php?tipo=file&id=<?= $impostazioni["fileDaCondividere"] ?>">Scarica</a>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
        
        function generaTabellaFileCartella($impostazioni) {
            $datiCartella = parent::getDb()->leggiSingolaRiga("geecD_cartelle",$impostazioni["cartellaDaCondividere"]);
            ?>
            <div class="col-12">

                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="far fa-folder mr-2"></i><?= $datiCartella["nome"] ?></h5>
                        <a class="btn btn-primary" href="scarica.php?tipo=zipCartella&id=<?= $impostazioni["cartellaDaCondividere"] ?>">Scarica tutto</a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th scope="col">Nome</th>
                                        <th scope="col">Ultima modifica</th>
                                        <th scope="col">Dimensioni (Mb)</th>
                                        <th scope="col"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                        $query = "SELECT * FROM geecD_documenti WHERE cartella = {$impostazioni["cartellaDaCondividere"]}";
                                        $risDocumentiCartella = parent::getDb()->eseguiQueryLettura($query);
                                        while($documento = $risDocumentiCartella->fetch_assoc()) {
                                            
                                            $queryUltimaVersione = "SELECT * FROM geecD_versioniDocumento WHERE idDocumento = {$documento["id"]} ORDER BY id DESC LIMIT 1";
                                            $risUltimaVersione   = parent::getDb()->eseguiQueryLettura($queryUltimaVersione);
                                            $datiUltimaVersione  = $risUltimaVersione->fetch_assoc();
                                            $dataUltimaModifica  = date("d/m/Y",strtotime($datiUltimaVersione["dataCreazione"]));
                                            ?>
                                            <tr>
                                                <td><i class="far fa-file mr-2"></i><?= $documento["nome"] ?></td>
                                                <td><?= $dataUltimaModifica ?></td>
                                                <td><?= $datiUltimaVersione["dimensione"] ?></td>
                                                <td><a data-toggle="tooltip" data-placement="bottom" title="Scarica" href="scarica.php?tipo=file&id=<?= $documento["id"] ?>"><i class="fas fa-arrow-down mr-2"></i>Scarica</a></td>
                                            </tr>
                                            <?php
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <a class="btn btn-primary" href="scarica.php?tipo=zipCartella&id=<?= $impostazioni["cartellaDaCondividere"] ?>">Scarica tutto</a>
                    </div>
                </div>
            </div>
            <?php
        }
    }